function y=rmsdb(x,Fs,windurms,wintype,emph);
%function y=rmsdb(x,Fs,windurms,wintype,emph);
% calculate rms of window
% Version 1.1 Modified to allow longer emph filters
% Copyright T.M. Nearey 1998-2002
% windurms = size of window in ms
tnargin=nargin;
if tnargin==0;
	emph=0;
	windurms=25;
	wintype='HAMMING'
	Fs=16000;
	t=0:1/Fs:.5;    
	nt=length(t)
	emph=.7;
	% 2 secs @ 10kHz sample rate
	nt1=floor(nt/2); nt2=nt-nt1;
    x=chirp(t,100,.5,500).*[linspace(10,0,nt1),linspace(0,10,nt2)]; 
	sizex=size(x)
	disp('ChirpDone');
	pause
else
	nt=length(x);
	if tnargin<4|isempty(wintype)
		wintype='HAMMING';
	end
	if tnargin<5|isempty(emph);
		emph=0;
	end
end
	
	nwin=ceil(windurms/1000*Fs);
	shft=ceil(nwin/2);
	shft2=nwin-shft;
	x=[x(:);zeros(shft,1)]; % pads end of signal with half a window of zeros
	if any(emph~=0)
		x = filter([1 -emph(:)'], 1, x);
	end
	%nwin, pause
	win=getwin(nwin,wintype); % normalize
	if tnargin==0
		figure(1); clf;
		plot(x); hold on;
		pause
	end
	x=x.^2/nwin;
	%tic
	y=10*log10(filter(win,1,x)+max(abs(x))/1e7);% 120 db down noise level (releative to maximum peak value in signal)
	y=y(shft2:shft2+nt-1); % delete the zero padding
	%toc
	if tnargin==0
		plot(y,'r'); hold on;
		pause;
	end
	
